<?

function ifAdvancedForm($Data) {
	global $data;

	foreach ($Data['fields'] as $Group => $FieldsGroup)
		foreach ($FieldsGroup as $Field)
			$Fields[$Group][] = AdvancedFormField($Field);
	foreach ($Fields as $Group => $Set) $Fields[$Group] = implode($Set);

	$Fields = "<div class='PopGroup Popular'>{$Fields['popular']}</div><div class='PopGroup NotPopular'>{$Fields['notPopular']}</div>";
	return "<div class='ifAdvancedForm' Data-FilterData='{$_GET['filterData']}' Data-AjaxLink='//{$_SERVER['HTTP_HOST']}".(generateLink2(array("params" => $Data["ajaxUrlParams"], "linkText" => $K), false))."&Ajax=1' Data-fpEncodeMethod='{$Data['parameters']['fpEncodeMethod']}' Data-fpFormDataUrlParamName='{$Data['parameters']['fpFormDataUrlParamName']}'><div class='FilterHeader'><span class='FilterSwitch'>{$data['siteLabels']['accessoriesFilterLabel']}</span></div><div class='Filters'><div class='PopFieldsButtons'><span class='Popular Active'>Популярные</span><span class='NotPopular'>Все</span></div>{$Fields}</div></div>";
}

function AdvancedFormField($Field) {
	if ($Field['type'] === 'range') {
		//Show($Field);
		//if ($Field['id']==13) {$Field['values']['min']=222; $Field['values']['max']=88888;}
		//if ($Field['id']==10) {$Field['values']['min']=333; $Field['values']['max']=777;}
		$Values = ["<div class='Range'><input class='Min' value='{$Field['range']['selectedLow']}' disabled autocomplete='off'><div class='Slider' Data-Min='{$Field['range']['minValue']}' Data-Max='{$Field['range']['maxValue']}' Data-Min='{$Field['values']['min']}' Data-Max='{$Field['values']['max']}'></div><input class='Max' value='{$Field['range']['selectedHigh']}' disabled autocomplete='off'></div>"];
	} else {
		foreach ($Field['values'] as $Group => $ValuesGroup)
			foreach ($ValuesGroup as $Value)
				$Values[$Group][] = AdvancedFormOption($Value);

		foreach ($Values as $Group => $Set)
			$Values[$Group] = "<div class='ValuePopGroup'>" . implode($Set) . "</div>";
		if (count($Values) > 1) $PopGroupButtons = "<div class='PopGroupButtons'><span class='Popular Active'>Популярные</span><span class='NotPopular'>Все</span></div>";
	}

	return "<div class='AdvancedFormField' Data-FieldType='{$Field['type']}' Data-FieldId='{$Field['id']}'>
				<div class='FieldHeader'><div class='Name'>{$Field['name']}</div>{$PopGroupButtons}</div>
				" . implode($Values) . "
			</div>";
}

function AdvancedFormOption($Value) {
	if ($Value['isSelected']) $Value['isSelected']='checked';
	return "<label><input type='checkbox' value='{$Value['value']}' {$Value['isSelected']} autocomplete='off'>{$Value['name']}</label>";
}


function ifPageSelector($Data) {

	if ($_GET['pageCount']) $Data["parameters"]["pageCount"] = $_GET['pageCount'];
	if ($Data["parameters"]["pageCount"] > 1) {
		if ($Data["parameters"]["pageCount"] <= 10)
			for ($i = 1; $i <= $Data["parameters"]["pageCount"]; $i++)
				$Keys[$i] = $i;
		else {
			$Keys = [1 => 1, $Data["parameters"]["pageCount"] => $Data["parameters"]["pageCount"]];
			$Step = $Data["parameters"]["pageCount"] / 8;
			for ($i = 0; $i <= 7; $i++)
				$Keys[$M = round(1 + $i * $Step)] = $M;
		}
		if ($Data["parameters"]["selectedPage"] > 1) {
			$Keys[$M = $Data["parameters"]["selectedPage"] - 1] = $M;
			$LeftArrow = "<li class='Arrow Left'><a href='//" . $_SERVER['HTTP_HOST'] . generateLink2(array("params" => array_merge($Data["parameters"]["urlParams"], array("page" => $Data["parameters"]["selectedPage"] - 1, "pageSize" => $Data["parameters"]["pageSize"])), "linkText" => $K), false) . "'>‹</a></li>";
			$LeftLeftArrow = "<li class='Arrow Left'><a href='//" . $_SERVER['HTTP_HOST'] . generateLink2(array("params" => array_merge($Data["parameters"]["urlParams"], array("page" => 1, "pageSize" => $Data["parameters"]["pageSize"])), "linkText" => $K), false) . "'>«</a></li>";
		}
		if ($Data["parameters"]["selectedPage"] < $Data["parameters"]["pageCount"]) {
			$Keys[$M = $Data["parameters"]["selectedPage"] + 1] = $M;
			$RightArrow = "<li class='Arrow Right'><a href='//" . $_SERVER['HTTP_HOST'] . generateLink2(array("params" => array_merge($Data["parameters"]["urlParams"], array("page" => $Data["parameters"]["selectedPage"] + 1, "pageSize" => $Data["parameters"]["pageSize"])), "linkText" => $K), false) . "'>›</a></li>";
			$RightRightArrow = "<li class='Arrow Right'><a href='//" . $_SERVER['HTTP_HOST'] . generateLink2(array("params" => array_merge($Data["parameters"]["urlParams"], array("page" => $Data["parameters"]["pageCount"], "pageSize" => $Data["parameters"]["pageSize"])), "linkText" => $K), false) . "'>»</a></li>";
		}
		asort($Keys);
		foreach ($Keys as $K) {
			if ($L and ($K - $L) != 1) $Pages[] = "<li class='Empty'>...</li>";
			$L = $K;
			$Pages[$K] = "<li class='Link'><a href='//" . $_SERVER['HTTP_HOST'] . generateLink2(array("params" => array_merge($Data["parameters"]["urlParams"], array("page" => $K, "pageSize" => $Data["parameters"]["pageSize"])), "linkText" => $K), false) . "'>{$K}</a></li>";
		}
		$Pages[$Data["parameters"]["selectedPage"]] = "<li class='Active'>{$Data["parameters"]["selectedPage"]}</li>";
		if ($Data["parameters"]["pageCount"] < 11) unset($LeftArrow, $LeftLeftArrow, $RightArrow, $RightRightArrow);
		return "<ul class='PageSelector'>{$LeftLeftArrow}{$LeftArrow}" . implode($Pages) . "{$RightArrow}{$RightRightArrow}</ul>";
	}
}

function ifForm($Data) {
	global $SiteLabels;
	$MaxRadioCount = 5;
	$InputTypes = ['selectable' => "type='radio'"];
	$Checked[1] = "checked=1";
	$Selected[1] = "selected=1";
	foreach ($Data['fields'] as $Field) {
		unset($Inputs);
		if ($InputTypes[$Field['type']] != 'selectable' and count($Field['values']) <= $MaxRadioCount and empty($Field['isLongValueNames'])) {
			foreach ($Field['values'] as $Input)
				$Inputs[] = "<label><input name='{$Field['id']}' {$InputTypes[$Field['type']]} {$Checked[$Input['isSelected']]} value='{$Input['value']}'><span>{$Input['name']}</span></label>";
			$Inputs = ImplodeIfArray($Inputs);
		} else {
			foreach ($Field['values'] as $Input)
				$Inputs[] = "<option value='{$Input['value']}' {$Selected[$Input['isSelected']]}>{$Input['name']}</option>";
			$Inputs = "<select name='{$Field['id']}'>" . ImplodeIfArray($Inputs) . "</select>";
		}
		$Fields[] = "<div class='Field'><div class='Header'>{$Field['name']}</div>{$Inputs}</div>";
		if ((!empty($Field['values'][0]['value']) and empty($Data['parameters']['fpFormDataUnknownValue'])) or (!empty($Data['parameters']['fpFormDataUnknownValue']) and $Field['values'][0]['value'] != $Data['parameters']['fpFormDataUnknownValue'])) $URLAppend[] = $Field['id'] . '=' . $Field['values'][0]['value'];
	}
	return "<div class='Form' data-FieldsDelimeter='{$Data['parameters']['fpFormFieldsDelimeter']}' data-ValuesDelimeter='{$Data['parameters']['fpFormValuesDelimeter']}' data-EncodeMethod='{$Data['parameters']['fpEncodeMethod']}' data-URL='" . ($URL = generateLink2(array("params" => $Data['urlParams'], "linkText" => $_GET['brand']), false) . "&{$Data['parameters']['fpFormDataUrlParamName']}=") . "'" . ($Data['parameters']['fpFormDataUnknownValue'] ? " data-fpFormDataUnknownValue='{$Data['parameters']['fpFormDataUnknownValue']}'" : '') . ">" . ImplodeIfArray($Fields) . "<a href='{$URL}" . base64_encode(ImplodeIfArray($URLAppend, $Data['parameters']['fpFormFieldsDelimeter'])) . "'><button>{$SiteLabels['openCatalog']}</button></a></div>";
}

function ifNoScriptData($Data) {
	foreach ($Data['values'] as $URL) {
		$URLs[] = "<a alt='{$URL['name']}' href='//" . $_SERVER['HTTP_HOST'] . generateLink2(array("params" => $URL['urlParams'], "linkText" => $_GET['brand']), false) . "'>{$URL['name']}</a>";
	}
	return "<noscript>" . ImplodeIfArray($URLs, '<br>') . "</noscript>";
}

function ifTile($Data) {
	$Tiles[] = Listing($Data, $Data['tileItemFormat']);
	return "<div class='Tiles'>" . ImplodeIfArray($Tiles) . "</div>";
}

function ifAdvancedTile($Data) {
	if ($Data['ifAdvancedTileAdditionalInfo']) {
		global $ifAdvancedTileAdditionalInfo;
		$ifAdvancedTileAdditionalInfo = 1;
	}

	$Tiles[] = Listing($Data, $Data['tileItemFormat']);
	return "<div class='Tiles AdvancedTiles'>" . ImplodeIfArray($Tiles) . "</div>";
}

function ifImage($Data) {
	if ($Data['image'])
		foreach ($Data['image'] as $Key => $Val) {
			switch ($Key) {
				case 'filename':
					if ($Data['image']['isStaticImage']) {
						$ImageUrl = '//static.neoriginal.ru' . "/images/{$_GET['brand']}/{$Val}";
					} else {
						$Image = getApiData(array("function" => "getImageHash", "brand" => $_GET['brand'], "filename" => $Val, "apiVersion" => '2.0'));
						$ImageUrl="//images.ilcats.ru/getImage.php?catalog={$_GET['brand']}&filename={$Val}&hash={$Image['data']['imageHash']}&domain={$_SERVER['HTTP_HOST']}";
					}
					break;
				case 'callouts':
					$ImageMap = generateImageMap($Data['image']['callouts']);
					break;
				case 'imageLinks':
					foreach ($Val as $ILs)
						if ($ILs['isActive']) $ImageLinks[] = "<a href='#' class='Disabled'>{$ILs['name']}</a>";
						else $ImageLinks[] = generateLink2(array("params" => array_merge(array("brand" => $_GET['brand'], "vin" => $_GET["vin"]), $ILs["urlParams"]), "linkText" => $ILs['name']));
					$ImageLinks = "<div>" . ImplodeIfArray($ImageLinks) . "</div>";
					break;
			}
		}
	return "<div class='Images'>
				<div id='ImagesControlPanel'><div><button class='ScaleStep First' data-Direction='-1'>-</button><button class='CurrentScale' disabled>100%</button><button class='ScaleStep Last' data-Direction='1'>+</button></div>" .
		ImplodeIfArray($ImageLinks) .
		"</div>
				<div class='ImageArea'><div class='Image'><img src='{$ImageUrl}' alt='{$Data['image']['alt']}' usemap='#myMap'>{$ImageMap}</div></div>
			</div>";
}

function Listing($Data, $ItemFormat, $ChildFormat = '', $TagsType = 'Div', $Child = '') {
	if ($ChildFormat and !$Child) {
		$WrapClass1 = 'Multilist';
		$HeaderWrap = array('Opening' => "<div class='Header'>", 'Closing' => '</div>');
	}
	if ($TagsType == 'Table') $Tags = array('Strings' => array('Opening' => "<td>", 'Closing' => '</td>'), 'Return' => array('Opening' => "<tr " . ($Data['values'][0]['callout'] !== '' ? "class='Active TR-{$Data['values'][0]['callout']}' data-ID='{$Data['values'][0]['callout']}'" : "") . ">", 'Closing' => '</tr>'));
	if ($TagsType == 'Div') $Tags = array('ListItems' => array('Opening' => "<div class='List'>", 'Closing' => '</div>'), 'Return' => array('Opening' => "<div class='List {$WrapClass1}'>", 'Closing' => '</div>'));
	if ($Child) {
		$Tags['Child'] = array();
	}
	foreach ($Data['values'] as $ListItem) {
		unset($Strings);
		foreach ($ItemFormat as $Class => $StringFormat) {
			if (--$PassQnt) continue;
			if ($TagsType == 'Table' and $ListItem['colspan']) {
				$Tags['Strings']['Opening'] = "<td colspan={$ListItem['colspan']}>";
				$PassQnt = $ListItem['colspan'];
			} else if ($TagsType == 'Table') $Tags['Strings']['Opening'] = "<td>";
			$Strings[] = $Tags['Strings']['Opening'] . Caption($ListItem, $StringFormat, $Class) . $Tags['Strings']['Closing'];
		}
		$ListItems[] = $Tags['ListItems']['Opening'] . $HeaderWrap['Opening'] . ImplodeIfArray($Strings) . $HeaderWrap['Closing'] . ($ChildFormat ? Listing($ListItem, $ChildFormat, '', 'Div', 1) : '') . $Tags['ListItems']['Closing'];
	}
	return $Tags['Return']['Opening'] . ImplodeIfArray($ListItems) . $Tags['Return']['Closing'];
}

function ifList($Data) {
	return Listing($Data, $Data['listItemFormat'], '', 'Div', 1);
}

function ifMultilist($Data) {
	return Listing($Data, $Data['multilistItemFormat'], $Data['multilistChildItemFormat']);
}

function ifTable($Data) {
	global $data;
	if ($Data['tableColumnHeaders']) {
		foreach ($Data['tableColumnHeaders'] as $ColHeaders) $Cols[] = "<th>{$ColHeaders}</th>";
		$RowHeaderSpan = count($Data['tableColumnHeaders']);
		$Rows[] = "<tr>" . ImplodeIfArray($Cols) . "</tr>";
	}
	foreach ($Data['values'] as $RowData)
		if ($RowData['isHeader']) $Rows[] = "<tr " . ($RowData['callout'] ? "class='Active TR-{$RowData['callout']}' data-ID='{$RowData['callout']}'" : "") . "><th colspan=" . ($RowData['colspan'] ? $RowData['colspan'] : $RowHeaderSpan) . ">{$RowData['name']}</th></tr>";
		else $Rows[] = Listing(array('values' => array(0 => $RowData)), $Data['tableItemFormat'], '', 'Table');
	if ($data['siteLabels']['close']) {
		$Labels[] = "Data-close='{$data['siteLabels']['close']}'";
		$Labels[] = "Data-additionalInfo='{$data['siteLabels']['additionalInfo']}'";
		$Labels[] = "Data-brand='" . ucwords($_GET['brand']) . "'";
		$Labels = ImplodeIfArray($Labels);
	}
	return $Table = "<table {$Labels}>" . ImplodeIfArray($Rows) . "</table>";
}

function Caption($Row, $StringFormat) {
	switch ($StringFormat['type']) {
		case '':
			foreach ($StringFormat as $PartStringFormat) $PartString[] = Caption($Row, $PartStringFormat);
			return ImplodeIfArray($PartString);
		case 'ifTable':
			foreach ($StringFormat['tableItemFormat'][0] as $Key => $Val) $StringFormat['tableItemFormat'][0][$Key]['caption'] = '{' . $StringFormat['tableItemFormat'][0][$Key]['caption'] . '}';
			return ifTable(array_merge($StringFormat, array('values' => $Row[$StringFormat['dataSource']])));

		default:
			$Row['linkedGroupName'] = $Row['partAdditionalInfo'];
			//Show($Row['linkedGroupName']);
			if ($StringFormat['image']) $StringFormat['caption'] = $StringFormat['image'];
			preg_match_all("/\{([a-zA-Z0-9]+)\}/i", $StringFormat['caption'], $Matches);
			if ($Matches[1]) {
				foreach ($Matches[1] as $Match) {
					if ($Replacing = $Row[$Match]) {
						$Changed++;
						switch ($StringFormat['type']) {
							case 'ifLink':
								if ($Match == 'linkedGroupName') {
									foreach ($Replacing as $K => $V) {
										if ($V) {
											$AddInfoLinks[] = generateLink2(array("params" => array_merge(array("brand" => $_GET['brand'], "vin" => $_GET["vin"], 'title' => $V['name']), $V["urlParams"]), "linkText" => "<img src='" . apiStaticContentHost . "/API.v2/Icons/{$V['urlParams']['function']}.png' 'alt'='{$V['name']}' 'title'='{$V['name']}' 'Data-Number'='{$V["urlParams"]['number']}'>"));
											$Replacing = ImplodeIfArray($AddInfoLinks);
										}
									}
								} else {
									$Replacing = generateLink2(array("params" => array_merge(array("brand" => $_GET['brand'], "vin" => $_GET["vin"]), $Row["urlParams"]), "linkText" => $Replacing));
								}
								break;
							case 'ifLinkArray':
								if ($Replacing) foreach ($Replacing as $PartNumber) $LinkArray[] = generateLink2(array("params" => array_merge(array("brand" => $_GET['brand'], "vin" => $_GET["vin"]), $PartNumber["urlParams"]), "linkText" => $PartNumber['name']));
								$Replacing = ImplodeIfArray($LinkArray, $StringFormat['linkDelimeter'] ? $StringFormat['linkDelimeter'] : ', ');
								break;
							case 'ifPartLink':
								$Replacing = generateArticleUrl2($Replacing);
								break;
							case 'ifPartLinkWBrand':
								$Replacing = generateBrandUrl($Replacing);
								break;
							case 'ifPartLinkArray':
								if ($Replacing) foreach ($Replacing as $PartNumber) $PartNumbers[] = generateArticleUrl2($PartNumber);
								$Replacing = ImplodeIfArray($PartNumbers, $StringFormat['linkDelimeter'] ? $StringFormat['linkDelimeter'] : ', ');
								break;
							case 'ifHeaderText':
								$Replacing = "<div class='ifHeaderText'><b>{$Replacing}</b></div>";
								break;
							case 'ifTileImage':
								if ($Replacing['magnifiedImageFilename'])
									$MagnifiedTitle = "Data-MagnifiedTitle=" . apiStaticContentHost . "/images/{$_GET['brand']}{$Replacing['magnifiedImageFilename']}";

								if ($Row['imageBig'])
									$MagnifiedTitle = "Data-imageBig=" . apiStaticContentHost . "/images/{$_GET['brand']}{$Row['imageBig']['filename']}";

								//Show($Row);
								global $ifAdvancedTileAdditionalInfo;
								if ($ifAdvancedTileAdditionalInfo)
									$Replacing = generateLink2(array("brand" => $_GET['brand'], "params" => array_merge(array("brand" => $_GET['brand'], "vin" => $_GET["vin"], 'function' => 'getTileAdditionalInfo', 'itemId' => $Row['itemId'])), "linkText" => "<img src='" . apiStaticContentHost . "/images/{$_GET['brand']}{$Replacing['filename']}' alt='{$_GET['brand']} {$Row['id']} {$Row['name']}' {$MagnifiedTitle}>"));
								else $Replacing = generateLink2(array("brand" => $_GET['brand'], "params" => array_merge(array("brand" => $_GET['brand'], "vin" => $_GET["vin"]), $Row["urlParams"]), "linkText" => "<img src='" . apiStaticContentHost . "/images/{$_GET['brand']}{$Replacing['filename']}' alt='{$_GET['brand']} {$Row['id']} {$Row['name']}' {$MagnifiedTitle}>"));
								break;
						}
					}
					$StringFormat['caption'] = str_replace("{{$Match}}", $Replacing, $StringFormat['caption']);
				}
			} else {
				switch ($StringFormat['type']) {
					case 'ifLink':
						$Changed++;
						$StringFormat['caption'] = generateLink2(array("params" => array_merge(array("brand" => $_GET['brand'], "vin" => $_GET["vin"]), $Row["urlParams"]), "linkText" => $StringFormat['caption']));
						break;
				}
			}
			if ($StringFormat['textAlign']) $Style = "style='text-align:{$StringFormat['textAlign']};'";
			return $Changed ? "<div class='{$Match}' {$Style}>" . $StringFormat['caption'] . "</div>" : ($Matches ? '' : $StringFormat['caption']);
	}
}

function MainMenu($Menu = array()) {
	if ($Menu)
		foreach ($Menu as $KeyS => $SubMenu) {

			foreach ($SubMenu as $Key => $Option) {
				//Show($Option);
				$Link["linkText"] = $Option['name'] . ": ";
				$Link["catRootUrl"] = $Option['link'];
				//if ($KeyS == 1 && $Key == 0) unset($Option['urlParams']['function']);
				if ($Option['urlParams']) $Link["params"] = array_merge(array("brand" => $_GET['brand']), $Option['urlParams']);
				else $Link["params"]=[];
				if (strlen($Option['label']) > 20) {
					$Label = substr($Option['label'], 0, strpos($Option['label'], ' ', 20));
					if (!$Label) $Label = $Option['label'];
					if ($Label != $Option['label']) {
						$Label = "<span title='{$Option['label']}'>{$Label}...</span>";
					}
				} else {
					$Label = $Option['label'];
				}

				$Options[] = generateLink2($Link) . $Label;
			}
		}
	if ($Options) {
		$MenuOptions = "<li>" . ImplodeIfArray($Options, "</li><li>") . "</li>";
	}
	return "<ul id='MainMenu'><li class='Image'><img src='".apiStaticContentHost. "/API.v2/Icons/Menu.png' alt='Menu'></li>{$MenuOptions}</ul>";
}

function Languages($Languages) {

	global $activeLanguages;
	if (count($activeLanguages))
		foreach ($Languages as $K=>$Language)
			if (!in_array($K, $activeLanguages)) unset($Languages[$K]);

	if ($Languages and count($Languages) > 1)
		foreach ($Languages as $Language) {
			if ($Language['isSelected']) $LIs[] = "<li class='Selected'><img src='" . apiStaticContentHost . "/images/{$Language['image']}' alt='{$Language['hint']}' title='{$Language['hint']}'></li>";
			else $LIs[] = "<li data-language='{$Language["urlParams"]['language']}'>" . ($Language["urlParams"] ? generateLink2(array("params" => array_merge(array("vin" => $_GET["vin"]), $Language["urlParams"]), "linkText" => "<img src='" . apiStaticContentHost . "/images/{$Language['image']}' alt='{$Language['hint']}' title='{$Language['hint']}'>")) : "<img src='" . apiStaticContentHost . "/images/{$Language['image']}' title='{$Language['hint']}' alt='{$Language['hint']}'>") . "</li>";
		}
	return "<div></div><ul id='Languages'>" . ImplodeIfArray($LIs) . "</ul>";
}

function generateImageMap($Callouts) {
	global $SiteLabels;
	foreach ($Callouts as $ID => $Callout) {
		foreach ($Callout as $CalloutAttrs) {
			$Map[] = "<div style='background-color:rgba(255,255,255,{$CalloutAttrs['opacity']});' " . ($CalloutAttrs['isNotApplicable'] ? "class='NotUsable' data-NotUsableAlert='{$SiteLabels['notApplicable']}' data-NotUsableTitle='{$SiteLabels['notApplicable']}'" : "class='Reg-{$CalloutAttrs['callout']} Opacity{$CalloutAttrs['opacity']}'") . " data-ID='{$CalloutAttrs['callout']}' data-Coords='" . json_encode([$CalloutAttrs['x'], $CalloutAttrs['y'], $CalloutAttrs['w'], $CalloutAttrs['h']]) . "'>{$CalloutAttrs['label']}</div>";
		}
	}
	return "<map name='myMap' id='myMap'>" . ImplodeIfArray($Map) . "</map>";
}

function VinForm($vinSearchParameters) {
	if ($vinSearchParameters['examples']) {
		foreach ($vinSearchParameters['examples'] as $Example) {
			$Examples[] = generateLink2(array("params" => array("brand" => $_GET['brand'], "vin" => $Example, "VinAction" => 'Search'), "linkText" => $Example));
		}
		$LinkTemplate = generateLink2(array("params" => array("brand" => $_GET['brand'], "vin" => 'vinValue', "VinAction" => 'Search')), false);
		if ($_GET['vin']) {
			$additionalParameters = array();
			if ($_GET['VinAcion'] != 'Search' and $vinSearchParameters['additionalParameters']) foreach ($vinSearchParameters['additionalParameters'] as $additionalParameter) $additionalParameters[$additionalParameter] = $_GET[$additionalParameter];
			$VinData = getApiData(array_merge(array("function" => "getVin", "brand" => $_GET['brand'], "vin" => $_GET['vin'], "apiVersion" => '2.0', "language" => $_GET['language']), $additionalParameters));
			//Show($VinData);
			if ($VinData['data']['vins']) {
				$CurrentVinInfo = "";
				foreach ($VinData['data']['vins'] as $Vin) {
					unset($TRs, $LIs);
					foreach ($Vin['description'] as $Label => $Val) $TRs[] = "<tr><td class='Left'>{$Label}</td><td>{$Val}</td></tr>";
					if ($Vin['options']) foreach ($Vin['options'] as $Label => $Val) $LIs[] = "<li><span>{$Label}</span> {$Val}</li>";
					if ($_GET['VinAction'] == 'Search' and $Vin['selectableValues'])
						foreach ($Vin['selectableValues'] as $Label => $Select) {
							unset($Options);
							$Selected[1] = 'selected';
							foreach ($Select['values'] as $Option)
								$Options[] = "<option value='{$Option['id']}' {$Selected[$Option['isSelected']]}>{$Option['name']}</option>";
							$TRs[] = "<tr><td class='Left'>{$Select['name']}</td><td><select data-Name='{$Select['urlParamName']}'><option value=''>{$Select['label']}</option>" . ImplodeIfArray($Options) . "</select></td></tr>";
						}
					$Vins[] = "<div class='VinCard'>
								<table>
									<tr><th colspan=2>{$Vin['shortDescription']}</th></tr>" .
						ImplodeIfArray($TRs) .
						"<tr class='" . ($_GET['VinAction'] == 'Search' ? '' : 'Hidden') . "'><td colspan=2 class='Center'>" . generateLink2(array("params" => array_merge(array("brand" => $_GET['brand'], "VinAction" => 'Choose'), $Vin["urlParams"]), "linkText" => $vinSearchParameters['openCatalogLabel'])) . "</td></tr>" .
						"</table>" .
						($LIs ? "
								<div class='Options'>
									<div class='Header'><span>{$vinSearchParameters['optionsListLabel']}</span><span class='Hide'>{$vinSearchParameters['hideLabel']}</span></div>
									<ul>" . ImplodeIfArray($LIs) . "</ul>
								</div>" : "") .
						"</div>";
				}
				if ($_GET['VinAction'] != 'Search' and count($VinData['data']['vins']) == 1) {
					$CurrentVin = "<span>{$VinData['data']['vins'][0]['shortDescription']}</span><span class='Hide'>{$vinSearchParameters['hideLabel']}</span>";
					if ($_GET['VinAction'] == 'Choose') {
						if ($_COOKIE['Vins']) $VinCookie = json_decode($_COOKIE['Vins'], true);
						$VinCookie[$_GET['brand']] = array_merge(array('vin' => $_GET['vin']), $additionalParameters);
						setcookie('Vins', json_encode($VinCookie), time() + 31536000, '/');
					}
				}
				$Vins = "<div class='VinInfo " . ($CurrentVin ? 'Hidden' : "") . "'>" . ImplodeIfArray($Vins) . "</div>";

			} else {
				$SearchMessage = $VinData['errors']['errorVinNotFound'];
			}
		} else {
			$SearchMessage = $vinSearchParameters['exampleLabel'] . ", " . ImplodeIfArray($Examples, ', ');
		}
	} else {
		$NoVinClass = 'NoVin';
	}
	return "<div id='Vins' class='{$NoVinClass}'>
				<div id='VinSearchForm'>
					<form data-Link='{$LinkTemplate}'>
						<input name='vin' value='{$_GET['vin']}'><button>{$vinSearchParameters['searchButtonCaption']}</button>
						<div class='SearchMessage" . ($SearchMessage ? '' : ' Hidden') . "'>{$SearchMessage}</div>
					</form>
					<div class='CurrentVin'>{$CurrentVin}</div>
				</div>
				{$Vins}
			</div>";
}

function ifButtonsSet($Catalogs) {
	global $data;
	if ($_GET['CSSManager'] and $_GET['cssdomain'])
		$UrlAppend = "&CSSManager={$_GET['CSSManager']}&cssdomain={$_GET['cssdomain']}";
	if (httpCatalogsPath) $CatalogsPath=httpCatalogsPath.'/'; else $CatalogsPath='';
	foreach ($Catalogs['values'] as $Catalog) {
		$CatalogGroup[] = "<a href='/{$CatalogsPath}{$Catalog['url']}{$UrlAppend}'><img src='{$Catalog['image']}' alt='{$data['stageName']} {$Catalog['name']}'>{$Catalog['name']}</a>";
	}
	return "<div class='CatalogGroup'>" . ImplodeIfArray($CatalogGroup) . "</div>";
}

?>